<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Privacy Policy</title>
    <meta name="viewport" content="width=device-width, initial-scale=1"> {{-- needed for mobile --}}
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    .about-gradient {
      background: linear-gradient(to right, #f8f9fa, #e3f2fd); /* soft gray to light blue */
    }

  .container ul li a {
   text-decoration: none; 
   background: linear-gradient(to right, #ffecd2, #fcb69f); 
   -webkit-background-clip: text;
    -webkit-text-fill-color: transparent; 
    font-weight: 800; 
  transition: color 0.3s ease;
}
.container ul li::after{
    content: '';
    width: 0%;
    height: 2px;
    background: goldenrod;
    display: block;
        margin: auto;
        transition: 0.5s;
}
.container ul li:hover::after{
    width: 100%;
}
.navbar-brand{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.dropdown-menu{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
}
.display-5{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.btn-primary{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  border: none;
}
.mb-4.text-center{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.btn-secondary{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  border: none;
}
  </style>
</head>
<body class="bg-light">

{{-- NAVBAR --}}
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container">
    {{-- Logo / Brand --}}
    <a class="navbar-brand fw-bold" href="{{ route('posts.index') }}">
      Candid Chronicles
    </a>

    {{-- Mobile toggle --}}
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain"
            aria-controls="navbarMain" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    {{-- Menu --}}
    <div class="collapse navbar-collapse" id="navbarMain">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">

        {{-- Home --}}
        <li class="nav-item">
          <a href="{{ route('posts.index') }}"
             class="nav-link {{ request()->routeIs('posts.index') ? 'active' : '' }}">
            Home
          </a>
        </li>

        {{-- About (dynamic page) --}}
        <li class="nav-item">
          <a href="{{ route('about') }}"
             class="nav-link {{ request()->routeIs('about') ? 'active' : '' }}">
            About
          </a>
        </li>

        {{-- Categories dropdown: News / Story / Lifestyle --}}
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle {{ request()->routeIs('category.show') ? 'active' : '' }}"
             href="#" id="navbarDropdown" role="button"
             data-bs-toggle="dropdown" aria-expanded="false">
            Categories
          </a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
            <li><a class="dropdown-item" href="{{ route('category.show', 'news') }}">News</a></li>
            <li><a class="dropdown-item" href="{{ route('category.show', 'story') }}">Story</a></li>
            <li><a class="dropdown-item" href="{{ route('category.show', 'lifestyle') }}">Lifestyle</a></li>
          </ul>
        </li>

        {{-- Archive (link to current year archive) --}}
        <li class="nav-item">
          <a href="{{ route('archive.year', now()->year) }}"
             class="nav-link {{ request()->routeIs('archive.*') ? 'active' : '' }}">
            Archive
          </a>
        </li>

        {{-- Contact --}}
        <li class="nav-item">
          <a href="{{ route('contact') }}"
             class="nav-link {{ request()->routeIs('contact') ? 'active' : '' }}">
            Contact
          </a>
        </li>

        {{-- Admin Login / Dashboard --}}
        <li class="nav-item ms-lg-3">
          @if(auth('admin')->check())
            <a href="{{ route('admin.posts.index') }}" class="btn btn-outline-light btn-sm me-2">
              Admin Dashboard
            </a>
            <form action="{{ route('admin.logout') }}" method="POST" class="d-inline">
              @csrf
              <button type="submit" class="btn btn-danger btn-sm">Logout</button>
            </form>
          @else
            <a href="{{ route('admin.login') }}" class="btn btn-outline-light btn-sm">
              Admin Login
            </a>
          @endif
        </li>

      </ul>
    </div>
  </div>
</nav>

    <div class="container py-4">
        <h1 class="mb-4">Privacy Policy</h1>

    <p>
        This Privacy Policy describes how we collect, use, and protect your information
        when you visit our website.
    </p>

    <h4>Information We Collect</h4>
    <p>
        We may collect personal information such as your name, email address,
        and any other information you voluntarily provide when you interact with
        our website (for example, when leaving comments).
    </p>

    <h4>Cookies</h4>
    <p>
        We use cookies to improve user experience. Cookies are small data files
        stored on your device that help us understand how visitors use our website.
    </p>

    <h4>Google AdSense</h4>
    <p>
        We use Google AdSense to display advertisements. Google uses cookies,
        including the DoubleClick cookie, to serve ads to users based on their visits
        to this and other websites.
    </p>

    <p>
        Google’s use of advertising cookies enables it and its partners to serve ads
        to our users based on their visit to our site and/or other sites on the Internet.
    </p>

    <p>
        Users may opt out of personalized advertising by visiting
        <a href="https://www.google.com/settings/ads" target="_blank" rel="nofollow">
            Google Ads Settings
        </a>.
    </p>

    <h4>Third-Party Advertising</h4>
    <p>
        Third-party ad servers or networks may use technologies like cookies,
        JavaScript, or Web Beacons in their respective ads. These are used to measure
        the effectiveness of advertising campaigns and/or to personalize the
        advertising content you see.
    </p>

    <p>
        We have no control over these cookies that are used by third-party advertisers.
    </p>

    <h4>Consent</h4>
    <p>
        By using our website, you hereby consent to our Privacy Policy and agree
        to its terms.
    </p>

    <h4>Updates</h4>
    <p>
        This Privacy Policy may be updated from time to time. Any changes will be
        posted on this page.
    </p>
    <p>
        If you have any questions about this Privacy Policy, please contact us
        at <strong><EMAIL>candidchronicles@yahoo.com</strong>.
    </p>
</div>
</div>
<footer class="py-4 bg-dark text-light mt-auto">
  <div class="container d-flex flex-column flex-md-row justify-content-between align-items-center">
    <div>
      © {{ date('Y') }} Candid Chronicles. All rights reserved.
    </div>
    <div class="mt-2 mt-md-0">
      <a href="https://twitter.com/CandidChro4351" class="text-light text-decoration-none me-3">Twitter</a>
      <a href="https://www.instagram.com/candid_chronicles00/" class="text-light text-decoration-none me-3">Instagram</a>
      <a href="https://www.facebook.com/share/1CW8Pn4ws9/?mibextid=wwXIfr" class="text-light text-decoration-none">Facebook</a>
    </div>
<div class="mt-2 mt-md-0">
    <a href="{{ route('privacy.policy') }}">Privacy Policy</a>
    | <a href="{{ route('terms') }}">Terms & Conditions</a>
  |
<a href="{{ route('contact') }}">Contact</a>
</div>

  </div>
  
</footer>

{{-- Bootstrap JS (required for navbar toggle + dropdowns) --}}
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
