<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Archive - Candid Chronicles</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <style>
       .container ul li a {
   text-decoration: none; 
   background: linear-gradient(to right, #ffecd2, #fcb69f); 
   -webkit-background-clip: text;
    -webkit-text-fill-color: transparent; 
    font-weight: 800; 
  transition: color 0.3s ease;
}
.container ul li::after{
    content: '';
    width: 0%;
    height: 2px;
    background: goldenrod;
    display: block;
        margin: auto;
        transition: 0.5s;
}
.container ul li:hover::after{
    width: 100%;
}
.navbar-brand{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.dropdown-menu{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
}
.display-5{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.btn-primary{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  border: none;
}
.mb-4.text-center{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.btn-secondary{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  border: none;
}
    </style>

{{-- NAVBAR (same as index.blade.php) --}}
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container">
    <a class="navbar-brand fw-bold" href="{{ route('posts.index') }}">
      Candid Chronicles
    </a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain"
            aria-controls="navbarMain" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarMain">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">

        <li class="nav-item">
          <a href="{{ route('posts.index') }}"
             class="nav-link {{ request()->routeIs('posts.index') ? 'active' : '' }}">
            Home
          </a>
        </li>

        <li class="nav-item">
          <a href="{{ route('about') }}"
             class="nav-link {{ request()->routeIs('about') ? 'active' : '' }}">
            About
          </a>
        </li>

        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle {{ request()->routeIs('category.show') ? 'active' : '' }}"
             href="#" id="navbarDropdown" role="button"
             data-bs-toggle="dropdown" aria-expanded="false">
            Categories
          </a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
            <li><a class="dropdown-item" href="{{ route('category.show', 'news') }}">News</a></li>
            <li><a class="dropdown-item" href="{{ route('category.show', 'story') }}">Story</a></li>
            <li><a class="dropdown-item" href="{{ route('category.show', 'lifestyle') }}">Lifestyle</a></li>
          </ul>
        </li>

        <li class="nav-item">
          <a href="{{ route('archive.year', now()->year) }}"
             class="nav-link {{ request()->routeIs('archive.*') ? 'active' : '' }}">
            Archive
          </a>
        </li>

        <li class="nav-item">
          <a href="{{ route('contact') }}"
             class="nav-link {{ request()->routeIs('contact') ? 'active' : '' }}">
            Contact
          </a>
        </li>

        <li class="nav-item ms-lg-3">
          @if(auth('admin')->check())
            <a href="{{ route('admin.posts.index') }}" class="btn btn-outline-light btn-sm me-2">
              Admin Dashboard
            </a>
            <form action="{{ route('admin.logout') }}" method="POST" class="d-inline">
              @csrf
              <button type="submit" class="btn btn-danger btn-sm">Logout</button>
            </form>
          @else
            <a href="{{ route('admin.login') }}" class="btn btn-outline-light btn-sm">
              Admin Login
            </a>
          @endif
        </li>

      </ul>
    </div>
  </div>
</nav>

{{-- HEADER --}}
<header class="py-5 bg-white border-bottom">
  <div class="container">
    <div class="row align-items-center gy-4">
      <div class="col-lg-7">
        <h1 class="display-5 fw-bold">
          Archive
        </h1>

        @if($month)
          <p class="lead text-muted">
            Posts from <strong>{{ \Carbon\Carbon::create($year, $month, 1)->format('F Y') }}</strong>
          </p>
        @else
          <p class="lead text-muted">
            Posts from <strong>{{ $year }}</strong>
          </p>
        @endif
      </div>

      <div class="col-lg-5">
        <form method="GET"
              action="{{ $month ? route('archive.month', [$year, $month]) : route('archive.year', $year) }}"
              class="d-flex gap-2">
          <input
            type="text"
            name="q"
            class="form-control"
            placeholder="Search in this archive..."
            value="{{ $search ?? '' }}"
          >
          <button class="btn btn-primary" type="submit">Search</button>
        </form>
      </div>
    </div>
  </div>
</header>

<div class="container py-5">
  @if(session('success'))
    <div class="alert alert-success">
      {{ session('success') }}
    </div>
  @endif

  @if($posts->count())
    <div class="row">
      @foreach($posts as $post)
        <div class="col-md-6 col-lg-4 mb-4">
          <div class="card h-100 shadow-sm">

            @if($post->image)
              <img src="{{ asset('storage/' . $post->image) }}" class="card-img-top" alt="Post image">
            @endif

            <div class="card-body d-flex flex-column">
              <small class="text-uppercase text-muted">
                {{ ucfirst($post->category ?? 'general') }}
              </small>

              <h5 class="card-title mt-1">{{ $post->title }}</h5>

              <p class="card-text text-muted">
                {{ Str::limit($post->body, 120) }}
              </p>

              @if($post->video)
                <span class="badge bg-secondary mb-2">🎥 Includes video</span>
              @endif

              <div class="mt-auto d-flex justify-content-between align-items-center">
                <a href="{{ route('posts.show', $post->slug) }}" class="btn btn-sm btn-primary">
                  Read More
                </a>
                <div class="text-muted small">
                  👍 {{ $post->likes->count() ?? 0 }}
                  &nbsp;·&nbsp;
                  💬 {{ $post->comments->count() ?? 0 }}
                  &nbsp;·&nbsp;
                  👁️ {{ $post->views ?? 0 }}
                </div>
              </div>

            </div>
          </div>
        </div>
      @endforeach
    </div>

    <div class="d-flex justify-content-center mt-4">
      {{ $posts->links() }}
    </div>
  @else
    <p class="text-center text-muted">No posts found for this archive period.</p>
  @endif
</div>

<footer class="py-4 bg-dark text-light mt-auto">
  <div class="container d-flex flex-column flex-md-row justify-content-between align-items-center">
    <div>
      © {{ date('Y') }} Candid Chronicles. All rights reserved.
    </div>
    <div class="mt-2 mt-md-0">
      <a href="https://twitter.com/CandidChro4351" class="text-light text-decoration-none me-3">Twitter</a>
      <a href="https://www.instagram.com/candid_chronicles00/" class="text-light text-decoration-none me-3">Instagram</a>
      <a href="https://www.facebook.com/share/1CW8Pn4ws9/?mibextid=wwXIfr" class="text-light text-decoration-none">Facebook</a>
    </div>
    <div class="mt-2 mt-md-0">
    <a href="{{ route('privacy.policy') }}">Privacy Policy</a>
    | <a href="{{ route('terms') }}">Terms & Conditions</a>
  |
<a href="{{ route('contact') }}">Contact</a>
  </div>

  </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
