<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Create Post</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
  <h1 class="mb-4 text-center">Create a New Post</h1>

    {{-- Validation errors --}}
  @if ($errors->any())
    <div class="alert alert-danger">
      <ul class="mb-0">
        @foreach ($errors->all() as $error)
          <li>{{ $error }}</li>
        @endforeach
      </ul>
    </div>
  @endif

  {{-- Success message (if you ever redirect back here with success) --}}
  @if (session('success'))
    <div class="alert alert-success">
      {{ session('success') }}
    </div>
  @endif


  <form method="POST" action="{{ route('admin.posts.store') }}" enctype="multipart/form-data">

  @csrf
  <div class="mb-3">
    <label for="title" class="form-label">Title</label>
    <input type="text" name="title" id="title" class="form-control" required>
  </div>

<div class="mb-3">
  <label for="category" class="form-label">Category</label>
  <select name="category" id="category" class="form-select" required>
    <option value="news">News</option>
    <option value="story">Story</option>
    <option value="lifestyle">Lifestyle</option>
  </select>
</div>


  <div class="mb-3">
    <label for="body" class="form-label">Content</label>
    <textarea name="body" id="body" class="form-control" rows="6" required></textarea>
  </div>

  <div class="mb-3">
    <label for="image" class="form-label">Upload Image (optional)</label>
    <input type="file" name="image" id="image" class="form-control" accept="image/*">
  </div>

  <div class="mb-3">
    <label for="video" class="form-label">Upload Video (optional)</label>
    <input type="file" name="video" id="video" class="form-control" accept="video/*">
  </div>

  <button type="submit" class="btn btn-success">Publish Post</button>
  <a href="{{ route('posts.index') }}" class="btn btn-secondary">Cancel</a>
</form>

</div>
</body>
</html>
