<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Edit Post</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container py-5">
  <a href="{{ route('posts.index') }}" class="btn btn-secondary mb-4">← Back</a>

  <div class="card shadow-sm">
    <div class="card-body">
      <h2 class="mb-4">Edit Post</h2>

      <form action="{{ route('admin.posts.update', $post) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="mb-3">
          <label for="title" class="form-label">Title</label>
          <input type="text" name="title" id="title" value="{{ old('title', $post->title) }}" class="form-control" required>
        </div>

<div class="mb-3">
  <label for="category" class="form-label">Category</label>
  <select name="category" id="category" class="form-select" required>
    <option value="news" {{ $post->category === 'news' ? 'selected' : '' }}>News</option>
    <option value="story" {{ $post->category === 'story' ? 'selected' : '' }}>Story</option>
    <option value="lifestyle" {{ $post->category === 'lifestyle' ? 'selected' : '' }}>Lifestyle</option>
  </select>
</div>


        <div class="mb-3">
          <label for="body" class="form-label">Body</label>
          <textarea name="body" id="body" rows="5" class="form-control" required>{{ old('body', $post->body) }}</textarea>
        </div>

        {{-- Show current image if exists --}}
        @if($post->image)
          <div class="mb-3">
            <label class="form-label">Current Image:</label><br>
            <img src="{{ asset('storage/' . $post->image) }}" class="img-fluid rounded mb-2" width="200">
          </div>
        @endif

        {{-- Show current video if exists --}}
        @if($post->video)
          <div class="mb-3">
            <label class="form-label">Current Video:</label><br>
            <video controls width="300" class="rounded mb-2">
              <source src="{{ asset('storage/' . $post->video) }}" type="video/mp4">
            </video>
          </div>
        @endif

        <div class="mb-3">
          <label for="image" class="form-label">Replace Image (optional)</label>
          <input type="file" name="image" id="image" class="form-control">
        </div>

        <div class="mb-3">
          <label for="video" class="form-label">Replace Video (optional)</label>
          <input type="file" name="video" id="video" class="form-control">
        </div>

        <button type="submit" class="btn btn-success">💾 Update Post</button>
      </form>
    </div>
  </div>
</div>

</body>
</html>
